/*
 * Decompiled with CFR 0.152.
 */
package com.smart.command;

import android.graphics.Bitmap;
import androidx.annotation.FloatRange;
import androidx.annotation.IntRange;
import com.smart.command.Utils;
import com.smart.utils.PictureProcess;
import java.io.UnsupportedEncodingException;
import java.util.Vector;

public class CpclCommand {
    private static final String DEBUG_TAG = "CpclCommand";
    Vector<Byte> Command = new Vector();

    public void clrCommand() {
        this.Command.clear();
    }

    public void addStrToCommand(String str) {
        byte[] bs = null;
        if (!str.equals("")) {
            try {
                bs = str.getBytes("GB2312");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            for (int i = 0; i < bs.length; ++i) {
                this.Command.add(bs[i]);
            }
        }
    }

    private void addArrayToCommand(byte[] array) {
        for (int i = 0; i < array.length; ++i) {
            this.Command.add(array[i]);
        }
    }

    public void addBytes(byte[] bytes) {
        for (int i = 0; i < bytes.length; ++i) {
            this.Command.add(bytes[i]);
        }
    }

    private void addStrToCommand(String str, TEXT_FONT font) {
        byte[] bs = null;
        if (!str.equals("")) {
            try {
                switch (font) {
                    case FONT_0: 
                    case FONT_1: 
                    case FONT_5: 
                    case FONT_7: 
                    case FONT_8: 
                    case FONT_20: 
                    case FONT_24: 
                    case FONT_28: 
                    case FONT_55: 
                    case FONT_56: 
                    case FONT_57: 
                    case FONT_2: {
                        bs = str.getBytes("gb18030");
                        break;
                    }
                    case FONT_91: 
                    case FONT_90: {
                        bs = str.getBytes("big5");
                        break;
                    }
                    case FONT_3: 
                    case FONT_4: {
                        bs = str.getBytes("gbk");
                        break;
                    }
                    case FONT_88: {
                        bs = str.getBytes("utf-8");
                        break;
                    }
                    case FONT_89: {
                        bs = str.getBytes("ksc5601");
                        break;
                    }
                    default: {
                        bs = str.getBytes("gb2312");
                        break;
                    }
                }
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            for (int i = 0; i < bs.length; ++i) {
                this.Command.add(bs[i]);
            }
        }
    }

    public void addInitializePrinter() {
        String str = "! 0 200 200 210 1\r\n";
        this.addStrToCommand(str);
    }

    public void addInitializePrinter(int qty) {
        String str = "! 0 200 200 210 " + qty + "\r\n";
        this.addStrToCommand(str);
    }

    public void addInitializePrinter(int height, int qty) {
        String str = "! 0 200 200 " + height + " " + qty + "\r\n";
        this.addStrToCommand(str);
    }

    public void addInitializePrinter(int offset, int height, int qty) {
        String str = "! " + offset + " 200 200 " + height + " " + qty + "\r\n";
        this.addStrToCommand(str);
    }

    public void addPrint() {
        String str = "PRINT\r\n";
        this.addStrToCommand(str);
    }

    public void addText(TEXT_FONT font, int size, int x, int y, String text) {
        String str = "TEXT " + font.getValue() + " " + size + " " + x + " " + y + " " + text + "\r\n";
        this.addStrToCommand(str, font);
    }

    public void addText90(TEXT_FONT font, int size, int x, int y, String text) {
        String str = "TEXT90 " + font.getValue() + " " + size + " " + x + " " + y + " " + text + "\r\n";
        this.addStrToCommand(str, font);
    }

    public void addText180(TEXT_FONT font, int size, int x, int y, String text) {
        String str = "TEXT180 " + font.getValue() + " " + size + " " + x + " " + y + " " + text + "\r\n";
        this.addStrToCommand(str, font);
    }

    public void addText270(TEXT_FONT font, int size, int x, int y, String text) {
        String str = "TEXT270 " + font.getValue() + " " + size + " " + x + " " + y + " " + text + "\r\n";
        this.addStrToCommand(str, font);
    }

    public void addText(TEXTFONT font, int size, int x, int y, String text, ALIGNMENT align, int n) throws NumberFormatException, UnsupportedEncodingException {
        boolean var1 = false;
        boolean var2 = false;
        boolean var3 = false;
        boolean var4 = false;
        if ((n & 1) == 1) {
            var1 = true;
        }
        if ((n & 2) == 2) {
            var2 = true;
        }
        if ((n & 4) == 4) {
            var3 = true;
        }
        if ((n & 8) == 8) {
            var4 = true;
        }
        if (var1) {
            this.addSetbold(BOLD.B5);
        }
        if (var4) {
            this.addSetmag(1, 2);
        }
        if (var3) {
            this.addSetmag(2, 1);
        }
        if (var4 & var3) {
            this.addSetmag(2, 2);
        }
        this.addJustification(align);
        switch (font) {
            case FONT_18: {
                this.addText(TEXT_FONT.FONT_55, size, x, y, text);
                break;
            }
            case FONT_24: {
                this.addText(TEXT_FONT.FONT_8, size, x, y, text);
                break;
            }
            case FONT_32: {
                this.addText(TEXT_FONT.FONT_4, size, x, y, text);
                break;
            }
        }
        if (var2) {
            float var13 = var3 ? (float)Integer.valueOf(x).intValue() + (float)text.getBytes("GBK").length * Float.parseFloat(font.getValue()) : (float)Integer.valueOf(x).intValue() + (float)text.getBytes("GBK").length * Float.parseFloat(font.getValue()) / 2.0f;
            if (var4) {
                this.addInverseLine(x, y, (int)var13, y, Integer.valueOf(font.getValue()) * 2);
            } else {
                this.addInverseLine(x, y, (int)var13, y, Integer.valueOf(font.getValue()));
            }
        }
        if (var3 | var4) {
            this.addSetmag(1, 1);
        }
        if (var1) {
            this.addSetbold(BOLD.B0);
        }
        this.addJustification(ALIGNMENT.LEFT);
    }

    public void addText180(TEXTFONT font, int size, int x, int y, String text, int n) throws NumberFormatException, UnsupportedEncodingException {
        boolean bold = false;
        boolean inverse = false;
        boolean doubleWidth = false;
        boolean doubleHeight = false;
        if ((n & 1) == 1) {
            bold = true;
        }
        if ((n & 2) == 2) {
            inverse = true;
        }
        if ((n & 4) == 4) {
            doubleWidth = true;
        }
        if ((n & 8) == 8) {
            doubleHeight = true;
        }
        if (bold) {
            this.addSetbold(BOLD.B5);
        }
        if (doubleHeight) {
            this.addSetmag(1, 2);
        }
        if (doubleWidth) {
            this.addSetmag(2, 1);
        }
        if (doubleHeight & doubleWidth) {
            this.addSetmag(2, 2);
        }
        this.addJustification(ALIGNMENT.LEFT);
        switch (font) {
            case FONT_18: {
                this.addText(TEXT_FONT.FONT_55, size, x, y, text);
                break;
            }
            case FONT_24: {
                this.addText(TEXT_FONT.FONT_8, size, x, y, text);
                break;
            }
            case FONT_32: {
                this.addText(TEXT_FONT.FONT_4, size, x, y, text);
                break;
            }
        }
        if (inverse) {
            float var13 = doubleWidth ? (float)text.getBytes("GBK").length * Float.parseFloat(font.getValue()) : (float)text.getBytes("GBK").length * Float.parseFloat(font.getValue()) / 2.0f;
            if (doubleHeight) {
                this.addInverseLine((int)((float)x - var13), y - Integer.valueOf(font.getValue()) * 2, x, y - Integer.valueOf(font.getValue()) * 2, Integer.valueOf(font.getValue()) * 2);
            } else {
                this.addInverseLine((int)((float)x - var13), y - Integer.valueOf(font.getValue()), x, y - Integer.valueOf(font.getValue()), Integer.valueOf(font.getValue()));
            }
        }
        if (doubleWidth | doubleHeight) {
            this.addSetmag(1, 1);
        }
        if (bold) {
            this.addSetbold(BOLD.B0);
        }
    }

    public void addTextConcat(int x, int y, String[] var) {
        String str = "CONCAT " + x + " " + y + "\r\n";
        for (int i = 0; i < var.length; ++i) {
            str = str + var[i] + "\r\n";
        }
        str = str + "ENDCONCAT\r\n";
        this.addStrToCommand(str);
    }

    public void addTextVconcat(int x, int y, String[] var) {
        String str = "CCONCAT " + x + " " + y + "\r\n";
        for (int i = 0; i < var.length; ++i) {
            str = str + var[i] + "\r\n";
        }
        str = str + "ENDCONCAT\r\n";
        this.addStrToCommand(str);
    }

    public String addConcatText(int font, int offset, String var) {
        String str = font + " 0 " + offset + " " + var;
        return str;
    }

    public void addTextEndconcat() {
        String str = "ENDCONCAT\r\n";
        this.addStrToCommand(str);
    }

    public void addConcatText(TEXT_FONT font, int offset, String text) {
        String str = font.getValue() + " 0 " + offset + " " + text + "\r\n";
        this.addStrToCommand(str, font);
    }

    public void addCount(String value) {
        String str = "COUNT " + value + "\r\n";
        this.addStrToCommand(str);
    }

    public void addSetmag(int w, int h) {
        if (w > 16) {
            w = 16;
        } else if (w < 1) {
            w = 1;
        }
        if (h > 16) {
            h = 16;
        } else if (h < 1) {
            h = 1;
        }
        String str = "SETMAG " + w + " " + h + "\r\n";
        this.addStrToCommand(str);
    }

    public void addBarcode(COMMAND command, BARCODETYPE type, int height, int x, int y, String text) {
        int width = 2;
        int ratio = 2;
        switch (type) {
            case UPC_A: {
                width = 2;
                ratio = 1;
                break;
            }
            case UPC_E: {
                width = 2;
                ratio = 1;
                break;
            }
            case EAN_13: {
                width = 2;
                ratio = 1;
                break;
            }
            case EAN_8: {
                width = 2;
                ratio = 1;
                break;
            }
            case CODE39: {
                width = 2;
                ratio = 2;
                break;
            }
            case CODE93: {
                width = 1;
                ratio = 0;
                break;
            }
            case CODE128: {
                width = 2;
                ratio = 1;
                break;
            }
            case CODABAR: {
                width = 2;
                ratio = 2;
                break;
            }
        }
        String str = command.getValue() + " " + type.getValue() + " " + width + " " + ratio + " " + height + " " + x + " " + y + " " + text + "\r\n";
        this.addStrToCommand(str);
    }

    public void addBarcode(COMMAND command, BARCODETYPE type, int height, int x, int y, int number, int offset, String text) {
        int width = 2;
        int ratio = 2;
        switch (type) {
            case UPC_A: {
                width = 2;
                ratio = 1;
                break;
            }
            case UPC_E: {
                width = 2;
                ratio = 1;
                break;
            }
            case EAN_13: {
                width = 2;
                ratio = 1;
                break;
            }
            case EAN_8: {
                width = 2;
                ratio = 1;
                break;
            }
            case CODE39: {
                width = 2;
                ratio = 2;
                break;
            }
            case CODE93: {
                width = 1;
                ratio = 0;
                break;
            }
            case CODE128: {
                width = 2;
                ratio = 1;
                break;
            }
            case CODABAR: {
                width = 2;
                ratio = 2;
                break;
            }
        }
        this.addBarcodeText(number, offset);
        String str = command.getValue() + " " + type.getValue() + " " + width + " " + ratio + " " + height + " " + x + " " + y + " " + text + "\r\n";
        this.addStrToCommand(str);
        this.addBarcodeTextOff();
    }

    public void addBarcode(COMMAND command, BARCODETYPE type, int width, BARCODERATIO ratio, int height, int x, int y, String text) {
        String str = command.getValue() + " " + type.getValue() + " " + width + " " + ratio.getValue() + " " + height + " " + x + " " + y + " " + text + "\r\n";
        this.addStrToCommand(str);
    }

    public void addBarcode(COMMAND command, BARCODETYPE type, int width, BARCODERATIO ratio, int height, int x, int y, int number, int offset, String text) {
        this.addBarcodeText(number, offset);
        String str2 = command.getValue() + " " + type.getValue() + " " + width + " " + ratio.getValue() + " " + height + " " + x + " " + y + " " + text + "\r\n";
        this.addStrToCommand(str2);
        this.addBarcodeTextOff();
    }

    public void addPdf417(COMMAND command, int x, int y, String data) {
        int xd = 2;
        int yd = 6;
        int c = 3;
        int s = 1;
        String str = command.getValue() + " PDF417 " + x + " " + y + " XD " + xd + " YD " + yd + " C " + c + " S " + s + "\r\n" + data + "\r\nENDPDF\r\n";
        this.addStrToCommand(str);
    }

    public void addPdf417(COMMAND command, int x, int y, int xd, int yd, int c, int s, String data) {
        String str = command.getValue() + " PDF417 " + x + " " + y + " XD " + xd + " YD " + yd + " C " + c + " S " + s + "\r\n" + data + "\r\nENDPDF\r\n";
        this.addStrToCommand(str);
    }

    public void addDataMatrix(int x, int y, int h, String content) {
        String str = String.format("BARCODE DATAMATRIX %d %d H %d\r\n%s\r\nENDDATAMATRIX\r\n", x, y, h, content);
        this.addStrToCommand(str);
    }

    public void addBarcodeText(int font, int offset) {
        String str = "BARCODE-TEXT " + font + " 0 " + offset + "\r\n";
        this.addStrToCommand(str);
    }

    public void addBarcodeTextOff() {
        String str = "BARCODE-TEXT OFF\r\n";
        this.addStrToCommand(str);
    }

    public void addBQrcode(QRCODE_LEVEL level, MODE mode, int x, int y, int n, int u, String text) {
        if (n > 2) {
            n = 2;
        } else if (n < 1) {
            n = 1;
        }
        if (u > 32) {
            u = 32;
        } else if (u < 1) {
            u = 1;
        }
        String str = "BARCODE QR " + x + " " + y + " M " + n + " U " + u + "\r\n" + level.getValue() + mode.getValue() + "," + text + "\r\nENDQR\r\n";
        this.addStrToCommand(str);
    }

    public void addBQrcode(QRCODE_LEVEL level, MODE mode, int x, int y, String text) {
        int n = 2;
        int u = 6;
        String str = "BARCODE QR " + x + " " + y + " M " + n + " U " + u + "\r\n" + level.getValue() + mode.getValue() + "," + text + "\r\nENDQR\r\n";
        this.addStrToCommand(str);
    }

    public void addVBQrcode(QRCODE_LEVEL level, MODE mode, int x, int y, int n, int u, String text) {
        if (n > 2) {
            n = 2;
        } else if (n < 1) {
            n = 1;
        }
        if (u > 32) {
            u = 32;
        } else if (u < 1) {
            u = 1;
        }
        String str = "VBARCODE QR " + x + " " + y + " M " + n + " U " + u + "\r\n" + level.getValue() + mode.getValue() + "," + text + "\r\nENDQR\r\n";
        this.addStrToCommand(str);
    }

    public void addVBQrcode(QRCODE_LEVEL level, MODE mode, int x, int y, String text) {
        int n = 2;
        int u = 6;
        String str = "VBARCODE QR " + x + " " + y + " M " + n + " U " + u + "\r\n" + level.getValue() + mode.getValue() + "," + text + "\r\nENDQR\r\n";
        this.addStrToCommand(str);
    }

    public void addPoPrint() {
        String str = "POPRINT\r\n";
        this.addStrToCommand(str);
    }

    public void addBox(int x, int y, int xEnd, int yEnd, int thickness) {
        String str = "BOX " + x + " " + y + " " + xEnd + " " + yEnd + " " + thickness + "\r\n";
        this.addStrToCommand(str);
    }

    public void addLine(int x, int y, int xEnd, int yEnd, int width) {
        String str = "LINE " + x + " " + y + " " + xEnd + " " + yEnd + " " + width + "\r\n";
        this.addStrToCommand(str);
    }

    public void addInverseLine(int x, int y, int xEnd, int yEnd, int width) {
        String str = "INVERSE-LINE " + x + " " + y + " " + xEnd + " " + yEnd + " " + width + "\r\n";
        this.addStrToCommand(str);
    }

    public void addEGraphics(int x, int y, int nWidth, int threshold, Bitmap bitmap) {
        if (bitmap != null) {
            int width = (nWidth + 7) / 8 * 8;
            int height = bitmap.getHeight() * width / bitmap.getWidth();
            Bitmap grayBitmap = Utils.toGrayscale(bitmap);
            Bitmap rszBitmap = Utils.resizeImage(grayBitmap, width, height);
            rszBitmap = PictureProcess.binaryzation(threshold, rszBitmap, false);
            byte[] src = Utils.bitmapToBWPix(rszBitmap);
            height = src.length / width;
            byte[] codecontent = Utils.pixToEscRastBitImageCmd(src);
            String data = this.toHexString1(codecontent);
            String str = "EG " + width / 8 + " " + height + " " + x + " " + y + " " + data + "\r\n";
            this.addStrToCommand(str);
        }
    }

    public String toHexString1(byte[] b) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < b.length; ++i) {
            buffer.append(this.toHexString2(b[i]));
        }
        return buffer.toString();
    }

    public String toHexString2(byte b) {
        String s = Integer.toHexString(b & 0xFF);
        if (s.length() == 1) {
            return "0" + s.toUpperCase();
        }
        return s.toUpperCase();
    }

    public void addCGraphics(int x, int y, int nWidth, int threshold, Bitmap bitmap) {
        if (bitmap != null) {
            int width = (nWidth + 7) / 8 * 8;
            int height = bitmap.getHeight() * width / bitmap.getWidth();
            Bitmap grayBitmap = Utils.toGrayscale(bitmap);
            Bitmap rszBitmap = Utils.resizeImage(grayBitmap, width, height);
            rszBitmap = PictureProcess.binaryzation(threshold, rszBitmap, false);
            byte[] src = Utils.bitmapToBWPix(rszBitmap);
            height = src.length / width;
            String str = "CG " + width / 8 + " " + height + " " + x + " " + y + " ";
            this.addStrToCommand(str);
            byte[] codecontent = Utils.pixToEscRastBitImageCmd(src);
            for (int k = 0; k < codecontent.length; ++k) {
                this.Command.add(codecontent[k]);
            }
            this.addStrToCommand("\r\n");
        }
    }

    public void addCGraphics(int x, int y, int nWidth, @FloatRange(from=-1.0, to=4.0) float contrastRatio, @FloatRange(from=-1.0, to=5.0) float brightness, Bitmap bitmap) {
        if (bitmap != null) {
            byte[] codeContent;
            int width = (nWidth + 7) / 8 * 8;
            int height = bitmap.getHeight() * width / bitmap.getWidth();
            Bitmap contrastBitmap = null;
            if (contrastRatio > 0.0f) {
                contrastBitmap = PictureProcess.contrast(bitmap, contrastRatio * 127.0f);
            }
            int[] srcPixels = contrastBitmap != null ? PictureProcess.bitmapToPixels(contrastBitmap) : PictureProcess.bitmapToPixels(bitmap);
            PictureProcess.gray(srcPixels, srcPixels, bitmap.getWidth(), bitmap.getHeight());
            Bitmap grayBitmap = PictureProcess.pixelsToBitmap(srcPixels, bitmap.getWidth(), bitmap.getHeight());
            Bitmap rszBitmap = Utils.resizeImage(grayBitmap, width, height);
            grayBitmap.recycle();
            Bitmap filterBitmap = PictureProcess.getFlyodBitmap(rszBitmap, brightness);
            byte[] src = Utils.bitmapToBWPix(filterBitmap);
            rszBitmap.recycle();
            height = src.length / width;
            String str = "CG " + width / 8 + " " + height + " " + x + " " + y + " ";
            this.addStrToCommand(str);
            for (byte b : codeContent = Utils.pixToEscRastBitImageCmd(src)) {
                this.Command.add(b);
            }
            this.addStrToCommand("\r\n");
        }
    }

    public void addWatermarkText(TEXT_FONT textFont, int size, int x, int y, @IntRange(from=0L, to=255L) int n, String text) {
        this.addStrToCommand("BACKGROUND " + n + "\r\n");
        String str = "BKT " + textFont.getValue() + " " + size + " " + x + " " + y + " " + text + "\r\n";
        this.addStrToCommand(str, textFont);
    }

    public void addJustification(ALIGNMENT align) {
        String str = align.getValue() + "\r\n";
        this.addStrToCommand(str);
    }

    public void addJustification(ALIGNMENT align, int end) {
        String str = align.getValue() + " " + end + "\r\n";
        this.addStrToCommand(str);
    }

    public void addPageWidth(int width) {
        String str = "PAGE-WIDTH " + width + "\r\n";
        this.addStrToCommand(str);
    }

    public void addSpeed(SPEED level) {
        String str = "SPEED " + level.getValue() + "\r\n";
        this.addStrToCommand(str);
    }

    public void addForm() {
        String str = "FORM\r\n";
        this.addStrToCommand(str);
    }

    public void addNote(String text) {
        String str = ";" + text + "\r\n";
        this.addStrToCommand(str);
    }

    public void addEnd() {
        String str = "END\r\n";
        this.addStrToCommand(str);
    }

    public void addSetsp(int spacing) {
        String str = "SETSP " + spacing + "\r\n";
        this.addStrToCommand(str);
    }

    public void addSetbold(BOLD value) {
        String str = "!U1 SETBOLD " + value.getValue() + "\r\n";
        this.addStrToCommand(str);
    }

    public void addWait(int time) {
        String str = "WAIT " + time + "\r\n";
        this.addStrToCommand(str);
    }

    public void addGapSense() {
        String str = "GAP-SENSE\r\n";
        this.addStrToCommand(str);
    }

    public void addBarSense() {
        String str = "BAR-SENSE\r\n";
        this.addStrToCommand(str);
    }

    public void addBarSenseLeft() {
        String str = "BAR-SENSE LEFT\r\n";
        this.addStrToCommand(str);
    }

    public void addQueryPrinterStatus() {
        byte[] command = new byte[]{27, 104};
        this.addArrayToCommand(command);
    }

    public void addQueryBatteryStatus() {
        byte[] command = new byte[]{16, 6, 3, 5, 12, 12};
        this.addArrayToCommand(command);
    }

    public Vector<Byte> getCommand() {
        return this.Command;
    }

    public static enum MODE {
        M("M"),
        A("A");

        private final String value;

        private MODE(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum QRCODE_LEVEL {
        H("H"),
        Q("Q"),
        L("L"),
        M("M");

        private final String value;

        private QRCODE_LEVEL(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum BOLD {
        B0("0"),
        B1("1"),
        B2("2"),
        B3("3"),
        B4("4"),
        B5("5");

        private final String value;

        private BOLD(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum COMMAND {
        BARCODE("BARCODE"),
        VBARCODE("VBARCODE");

        private final String value;

        private COMMAND(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum COUNTRY {
        PC850("PC850"),
        PC852("PC852"),
        PC860("PC860"),
        FRANCE("PC863"),
        PC865("PC865"),
        PC866("PC866"),
        PC858("PC858"),
        PC747("PC747"),
        PC864("PC864"),
        PC1001("PC1001"),
        PT1251("PT1251"),
        WPC1253("WPC1253"),
        WPC1254("WPC1254"),
        WPC1257("WPC1257"),
        KATAKANA("KATAKANA"),
        WEST_EUROPE("WEST_EUROPE"),
        GREEK("GREEK"),
        HEBREW("HEBREW"),
        EAST_EUROPE("EAST_EUROPE"),
        IRAN("IRAN"),
        IRANII("IRANII"),
        LATVIAN("LATVIAN"),
        ARABIC("ARABIC"),
        UYGUR("UYGUR"),
        THAI("THAI"),
        USA("PC473");

        private final String value;

        private COUNTRY(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum SPEED {
        SPEED0("0"),
        SPEED1("1"),
        SPEED2("2"),
        SPEED3("3"),
        SPEED4("4"),
        SPEED5("5");

        private final String value;

        private SPEED(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum ALIGNMENT {
        CENTER("CENTER"),
        LEFT("LEFT"),
        RIGHT("RIGHT");

        private final String value;

        private ALIGNMENT(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum BARCODERATIO {
        OpointF("0"),
        TpointZ1("1"),
        TpointF1("2"),
        ThpointZ1("3"),
        ThpointF("4"),
        TpointZ2("20"),
        TpointO("21"),
        TpointT("22"),
        TpointTh("23"),
        TpointFo("24"),
        TpointF2("25"),
        TpointS("26"),
        TpointSe("27"),
        TpointE("28"),
        TpointN("29"),
        ThpointZ2("30");

        private final String value;

        private BARCODERATIO(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum BARCODETYPE {
        CODE128("128"),
        UPC_A("UPCA"),
        UPC_E("UPCE"),
        EAN_13("EAN13"),
        EAN_8("EAN8"),
        CODE39("39"),
        CODE93("93"),
        CODABAR("CODABAR");

        private final String value;

        private BARCODETYPE(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum TEXTFONT {
        FONT_18("18"),
        FONT_24("24"),
        FONT_32("32");

        private final String value;

        private TEXTFONT(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum TEXT_FONT {
        FONT_0("0"),
        FONT_1("1"),
        FONT_2("2"),
        FONT_3("3"),
        FONT_4("4"),
        FONT_5("5"),
        FONT_7("7"),
        FONT_8("8"),
        FONT_20("20"),
        FONT_24("24"),
        FONT_28("28"),
        FONT_55("55"),
        FONT_56("56"),
        FONT_57("57"),
        FONT_88("88"),
        FONT_89("89"),
        FONT_90("90"),
        FONT_91("91");

        private final String value;

        private TEXT_FONT(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

